/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal.command;

import com.aptana.projects.wizards.AbstractNewProjectWizard;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class NewProjectFromTemplateCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String wizardId = event.getParameter("newWizardId");
        String templateName = event.getParameter("projectTemplateId");
        IWizardRegistry wizardRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardDescriptor wizardDescriptor = wizardRegistry.findWizard(wizardId);
        if (wizardDescriptor == null) {
            throw new ExecutionException("unknown wizard: " + wizardId);
        }
        try {
            IWorkbenchWizard wizard = wizardDescriptor.createWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            if (wizard instanceof IExecutableExtension) {
                ((IExecutableExtension)wizard).setInitializationData(null, "projectTemplateId", (Object)templateName);
            }
            if (wizardDescriptor.canFinishEarly() && !wizardDescriptor.hasPages()) {
                wizard.performFinish();
                return this.getProject(wizard);
            }
            Shell parent = UIUtils.getActiveShell();
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            dialog.open();
            return this.getProject(wizard);
        }
        catch (CoreException ex) {
            throw new ExecutionException("error creating wizard", (Throwable)ex);
        }
    }

    private IProject getProject(IWorkbenchWizard wizard) {
        if (wizard instanceof AbstractNewProjectWizard) {
            return ((AbstractNewProjectWizard)wizard).getCreatedProject();
        }
        return null;
    }
}

